package eu.mulk.mulkcms2.benki.users;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;

public class UserDefaultTargetPK implements Serializable {

  private int userId;
  private int targetId;

  @Column(name = "user", nullable = false)
  @Id
  public int getUserId() {
    return userId;
  }

  public void setUserId(int userId) {
    this.userId = userId;
  }

  @Column(name = "target", nullable = false)
  @Id
  public int getTargetId() {
    return targetId;
  }

  public void setTargetId(int targetId) {
    this.targetId = targetId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    UserDefaultTargetPK that = (UserDefaultTargetPK) o;

    if (userId != that.userId) {
      return false;
    }
    if (targetId != that.targetId) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = userId;
    result = 31 * result + targetId;
    return result;
  }
}
